#!/bin/bash

###################### MERGE SOURCE TREE  ##########################

if [ $# -lt 1 ]; then
	echo "请输入源分支"
	exit
fi

git reset --hard
THIS_BRANCH=`git branch | grep "*"  | awk -F' ' '{print $2}'`

git checkout -b my_test --force

LAST_VERSION=`git log  -n 1  --pretty="%H" Makefile`
SRC_BRANCH=$1

# 展开合并
git merge $SRC_BRANCH

# 提交合并
COMMIT_MSG=`git shortlog HEAD...${LAST_VERSION}`

git checkout $THIS_BRANCH --force

git merge --no-commit --no-ff $SRC_BRANCH
git commit -s -m "Merge branch $SRC_BRANCH into $THIS_BRANCH

$COMMIT_MSG
"
git branch -D my_test

###################### UPDATE KERNEL VERSION ##########################

TMPFILE=".changelog"

# 更新 Makefile 的版本信息
NOW=`date "+%Y%m%d"`
sed -i "/EXTRAVERSION = -20/d" Makefile
sed -i "/SUBLEVEL =/aEXTRAVERSION = -${NOW}" Makefile
SUBLEVEL=`sed -n 's/^SUBLEVEL = //p' Makefile`

# 创建 .changelog 临时文件
echo "kylin (4.4.${SUBLEVEL}-${NOW}.kylin) v100; urgency=low" > $TMPFILE
echo "" >> $TMPFILE
git log HEAD...${LAST_VERSION} --pretty=oneline --pretty="format:  * [%h]" | sort >> $TMPFILE
echo "" >> $TMPFILE
echo " -- JackieLiu <liuyun01@kylinos.cn>  `date -R`" >> $TMPFILE
echo "" >> $TMPFILE
sed -i "/Merge branch/d" $TMPFILE
cat debian/changelog >> $TMPFILE

## 覆盖 debian/changelog 文件
\mv $TMPFILE debian/changelog

DATE=`date '+%Y-%m-%d'`
git commit -s -am  "Update kernel version to ${DATE}

更新内核至 ${DATE}"
