#ifndef _LINUX_T10_PI_H
#define _LINUX_T10_PI_H

#include <linux/types.h>
#include <linux/blkdev.h>

/*
 * T10 Protection Information tuple.
 */
struct t10_pi_tuple {
	__be16 guard_tag;	/* Checksum */
	__be16 app_tag;		/* Opaque storage */
	__be32 ref_tag;		/* Target LBA or indirect LBA */
};

static inline u32 t10_pi_ref_tag(struct request *rq)
{
	unsigned int shift = ilog2(queue_logical_block_size(rq->q));

#ifdef CONFIG_BLK_DEV_INTEGRITY
	if (rq->q->integrity.interval_exp)
		shift = rq->q->integrity.interval_exp;
#endif
	return blk_rq_pos(rq) >> (shift - 9) & 0xffffffff;
}

extern struct blk_integrity_profile t10_pi_type1_crc;
extern struct blk_integrity_profile t10_pi_type1_ip;
extern struct blk_integrity_profile t10_pi_type3_crc;
extern struct blk_integrity_profile t10_pi_type3_ip;

#endif
