#ifndef KYSECURITY_INCLUDE_H
#define KYSECURITY_INCLUDE_H

#ifdef CONFIG_SECURITY_KYSEC

#include <linux/fs.h>
#include <linux/dcache.h>
#include <linux/binfmts.h>

#define KYSEC_VERSION			"4.3"

#define EXECTL_OFFSET			0
#define IDENTIFY_OFFSET			6
#define PROTECT_OFFSET			4

#define SECADM_COMMAND			(0x01 << IDENTIFY_OFFSET)
#define AUDADM_COMMAND			(0x02 << IDENTIFY_OFFSET)
#define SYSADM_COMMAND			(0x03 << IDENTIFY_OFFSET)

#define KYSEC_INTEGRITY_NONE		(0x00 << PROTECT_OFFSET)
#define KYSEC_INTEGRITY_PROTECT		(0x01 << PROTECT_OFFSET)
#define KYSEC_INTEGRITY_CHECK		(0x02 << PROTECT_OFFSET)

#define EXECTL_UNKNOWN			0x0
#define EXECTL_ORIGINAL			0x1
#define EXECTL_VERIFIED			0x3
#define EXECTL_KYSOFT			0x4
#define EXECTL_TRUSTED			0x9
#define EXECTL_PARENT			0xa

#define EXECTL_INVALID			0xb

#define EXECTL_ORIGINAL_ALWAYS	EXECTL_ORIGINAL
#define EXECTL_VERIFIED_KYSOFT	EXECTL_KYSOFT
#define EXECTL_TRUSTED_READ		EXECTL_TRUSTED

/*
 * 00				01		0000
 * identify bit	protect bit	exec bit
 */

#define EXECTL_MASK		0xf
#define IDENTIFY_MASK		(0x3 << IDENTIFY_OFFSET)
#define PROTECT_MASK		(0x3 << PROTECT_OFFSET)


#define XATTR_KYSEC_SUFFIX "kysec"
#define XATTR_NAME_KYSEC (XATTR_SECURITY_PREFIX XATTR_KYSEC_SUFFIX)

#define XATTR_EXECTL_SUFFIX "exectl"
#define XATTR_NAME_EXECTL (XATTR_SECURITY_PREFIX XATTR_EXECTL_SUFFIX)


#define INTEGRITY_PROTECTED(sid) (sid & PROTECT_MASK & KYSEC_INTEGRITY_PROTECT)
#define VERIFY_NEEDED(sid) (sid & PROTECT_MASK & KYSEC_INTEGRITY_CHECK)

#define EXECTL_LABEL(sid)			(sid & EXECTL_MASK)
#define PROTECT_LABEL(sid)			(sid & PROTECT_MASK)
#define IDENTIFY_LABEL(sid)			(sid & IDENTIFY_MASK)

#define NEW_EXECTL_LABEL(sid, exectl_sid) ((sid & (~EXECTL_MASK)) | exectl_sid)
#define NEW_PROTECT_LABEL(sid, protect_sid) ((sid & (~PROTECT_MASK)) | protect_sid)
#define NEW_IDENTIFY_LABEL(sid, identify_sid) ((sid & (~IDENTIFY_MASK)) | identify_sid)

void kysec_trusted_tmpfile_set_unknown(struct inode *inode);
void kysec_notify_inode_create(struct inode *dir, struct dentry *dentry);
void kysec_ppro_critical_monitor(struct linux_binprm *bprm);

#endif

#endif
