#ifndef __FT_MCUINFO_H__
#define __FT_MCUINFO_H__

#include <linux/types.h>

#define LAN_MAC_ADDR    0xA0

struct ft_mcuinfo_ops {
        int (*read)(u8 *buf, loff_t off, size_t count);
        int (*write)(u8 *buf, loff_t off, size_t count);
};

#ifdef CONFIG_FT_MCUINFO
int ft_mcu_read(u8 *buf, loff_t off, size_t count);
int ft_mcu_write(u8 *buf, loff_t off, size_t count);
int ft_mcuinfo_register(struct ft_mcuinfo_ops *ops);
bool is_ft_mcu_ready(void);
#else
static inline int ft_mcu_read(u8 *buf, loff_t off, size_t count) { return -1; }
static inline int ft_mcu_write(u8 *buf, loff_t off, size_t count) { return -1; }
static inline int ft_mcuinfo_register(struct ft_mcuinfo_ops *ops) { return -1; }
static inline bool is_ft_mcu_ready(void) { return false; }
#endif

#endif
