/*
 *  Authors: Jackie Liu <liuyun01@kylinos.cn>
 *
 *  Copyright (C) 2018,Tianjin KYLIN Information Technology Co., Ltd.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _MACHINE_TYPE_H_
#define _MACHINE_TYPE_H_

#include <linux/types.h>
#include <asm/phytium_platform.h>

int acpi_init_cpu_type(void);
bool phytium_get_cpu_type(u32 cpu_type);
/*
 * Phytium CPU VENDOER_ID defined as:
 * SIGNATURE_32 ('P','H','Y','T') in bios
 */
#define PHYTIUM_VENDOER_ID	0x54594850

/* phytium2000a4 */
#define ACPI_FT2000_4_X		0x000300
#define ACPI_FT2000_4		0x000301
#define ACPI_FT2000_4_S		0x000302
#define ACPI_FT2000_4_I		0x000303
#define ACPI_FT2000_4_SI	0x000304
#define ACPI_FT2000_4_2		0x000305
#define ACPI_FT2000_4_I2	0x000306
#define ACPI_FT2000_4_I1	0x000307
#define ACPI_FT2000_4_M		0x000308
#define ACPI_FT2000_4_EN	0x000311
#define ACPI_FT2000_4_BC	0x000313
#define ACPI_FT2000_4_ULP4C	0x000318

/* phytium2500 */
#define ACPI_S2500_64		0x000400
#define ACPI_S2500_64_C00	0x000401
#define ACPI_S2500_64_I00	0x000402
#define ACPI_S2500_56_C00	0x000403
#define ACPI_S2500_56_I00	0x000404
#define ACPI_S2500_48_C00	0x000405
#define ACPI_S2500_48_I00	0x000406

/* phytiumD2000 */
#define ACPI_D2000_8		0x000500
#define ACPI_D2000_8_B8C	0x000501
#define ACPI_D2000_8_E8C	0x000502
#define ACPI_D2000_8_S8C	0x000503
#define ACPI_D2000_8_S8I	0x000504
#define ACPI_D2000_4_S4C	0x000505
#define ACPI_D2000_4_S4I	0x000506
#define ACPI_D2000_8_ULP8C	0x000508
#define ACPI_D2000_8_E8C2	0x000509
#define ACPI_D2000_8_M8C	0x00050A
#define ACPI_D2000_8_EN8I	0x00050D

#define is_ft1500a()	is_part(MIDR_FT_1500A)
#define is_ft2000ahk()	is_part(MIDR_FT_2000AHK)
#define is_ft2000plus()	is_part(MIDR_FT_2000PLUS)
#define is_ft2500()	phytium_get_cpu_type(ACPI_S2500_64)
/* for phytium D2000 */
#define is_ftd2000()	phytium_get_cpu_type(ACPI_D2000_8)
/* for phytium D2000, FT2000a4 */
#define is_ft2000_pc()	(is_part(MIDR_FT_2000A_4) && !is_ft2500())
#define is_ft2000a4()   phytium_get_cpu_type(ACPI_FT2000_4_X)
#define is_ft_all()	is_implementer(ARM_CPU_IMP_PHYTIUM)

#define is_kunpeng920()	is_part(MIDR_HISI_TSV110)
#define is_hisi()	is_implementer(ARM_CPU_IMP_HISI)

extern int acpi_cpu_type;
extern u32 phytium_platform_id;
struct cpu_mode_desc {
	u32 midr_model;
	char *desc;
};
#endif
