/**
 * Copyright(C), 2002-2016, Kylin Tech. Co., Ltd.
 * PROJECT	: "706所ec电池管理驱动，I/O读操作部分"
 * DATE		: 2016-01-08
 * AUTHOR	: xiongxin
 * Hstory	:
 * <author>			<time>			<version>			<desc>
 * xiongxin			2015-05-24			1.0				ec电池驱动
 */

#ifndef __EC_6C68_H__
#define __EC_6C68_H__
#include <linux/io.h>
#include <linux/delay.h>
#include <asm/phytium_platform.h>

#define TIMEDELAY				10
#define EC_IBF					(1 << 1)			/* 1 = Input buffer full (data ready for ec) */
#define EC_OBF					(1 << 0)			/* 1 = Output buffer full (data ready for host) */

/*
 * the default ec port value,some boards may should modified the value.
 */
#define ec_cmd_port  0x6c
#define ec_dat_port  0x68
#define ec_sts_port  0x68

/*
 * ACPI legacy commands.
 */
#define CMD_READ_EC				0x80		/* Read EC command */
#define CMD_WRITE_EC				0x81		/* Write EC command */

#define MASK(x)					(1 << x)

static unsigned char ec_6c68_read(unsigned char index);
unsigned char ec_6c68_write(unsigned char index, unsigned char data);

static DEFINE_SPINLOCK(index_access_lock);

#ifdef CONFIG_FT_LPC
static inline void send_ec_command(unsigned char command)
{
	if (lpc_base == NULL){
		printk(KERN_ERR "lpc_base no maped!\n");
		return;
	}

	writeb(command, lpc_base + ec_cmd_port);
	mdelay(TIMEDELAY);
}

static inline void send_ec_data(unsigned char data)
{
	if (lpc_base ==NULL){
		printk(KERN_ERR "lpc_base no maped!\n");
		return;
	}

	writeb(data, lpc_base + ec_dat_port);
	mdelay(TIMEDELAY);
}

static unsigned char recv_ec_data(void)
{
	if (lpc_base == NULL){
		printk(KERN_ERR "lpc_base no maped!\n");
		return 0;
	}

	return readb(lpc_base + ec_dat_port);
}
#else
static inline void send_ec_command(unsigned char command)
{
}

static inline void send_ec_data(unsigned char data)
{
}

static unsigned char recv_ec_data(void)
{
	return 0;
}
#endif

unsigned char ec_6c68_read(unsigned char index)
{
	unsigned char value = 0;

	spin_lock(&index_access_lock);

	send_ec_command(CMD_READ_EC);
	send_ec_data(index);
	value = recv_ec_data();

	spin_unlock(&index_access_lock);

	return value;
}

#endif
