#!/bin/bash

if [ `whoami` != "root" ]; then
	echo "Need sudo"
	exit
fi

if [ $# -lt 2 ]; then
	echo "sudo release-kernel.sh admin@email.com desktop.config extend_patch"
	exit
fi

set -x

ADMIN_EMAIL="jiangdi@kylinos.cn"
EMAILLIST=$1
shift
IP=`ip addr  | grep 172.29 | awk -F' ' '{print $2}' | awk -F'/' '{print $1}' | head -1`
ARCHITECTURE=`uname -m`

./scripts/buildpackage.sh $@
if [ $? -ne 0 ]; then
	echo "请进入编译系统查看详情。" | s-nail -s "内核编译失败" $ADMIN_EMAIL
	exit -1;
fi

SUFFIX=`cat debian/build/build-generic/.config | grep LOCALVERSION= | awk -F'"' '{print $2}' | awk -F'.' '{print $3}'`
VERSION=`cat Makefile  | grep VERSION | head -n 1 | awk -F' = ' '{print $2}'`
PATCHLEVEL=`cat Makefile  | grep PATCHLEVEL | head -n 1 | awk -F' = ' '{print $2}'`
SUBLEVEL=`cat Makefile  | grep SUBLEVEL | head -n 1 | awk -F' = ' '{print $2}'`
EXTRAVERSION=`cat Makefile | grep "EXTRAVERSION =" | head -n 1 | awk -F'-'  '{print $2}'`

GIT_VERSION=`git log --oneline  | head -n 1  | awk -F' ' '{print $1}'`
KERNEL_VERSION=${VERSION}.${PATCHLEVEL}.${SUBLEVEL}-${EXTRAVERSION}-g${GIT_VERSION}
BRANCH_VERSION=`git branch | grep "\*" | awk -F'*' '{print $2}' | sed 's/^.//g'`

flock -w 10000 /tmp/virtual-system.LOCK /virtual-system/boot-test.sh ../kylin-image*.deb
if [ $? -eq 0 ]; then
	DATE=`date '+%Y-%m-%d_%H_%M'`
	rm -rf ../*source*deb
	tar -zcvf "release-${KERNEL_VERSION}-${SUFFIX}-package.tar.gz" ../*deb
	rm -rf ../*deb
	mkdir -p /var/data/ftpdata/robot/${DATE}/
	mv release-${KERNEL_VERSION}-${SUFFIX}-package.tar.gz /var/data/ftpdata/robot/${DATE}/

s-nail -vs " 内核发布 ${DATE}" $EMAILLIST << EOF
【下载链接】：ftp://${IP}/robot/${DATE}/release-${KERNEL_VERSION}-${SUFFIX}-package.tar.gz
【主线版本】：${KERNEL_VERSION}
【应用架构】：${ARCHITECTURE}
【个性版本】：${SUFFIX}
【分支版本】：${BRANCH_VERSION}
EOF

else
	echo "请进入编译系统查看详情。" | s-nail -s "内核启动测试失败" $ADMIN_EMAIL
	exit -2;
fi
