#ifndef __ASM_MACH_LOONGSON64_IRQ_H_
#define __ASM_MACH_LOONGSON64_IRQ_H_

#include <boot_param.h>

#ifdef CONFIG_CPU_LOONGSON3

#define NR_IRQS	(64 + 256)

#define IPI_IRQ_OFFSET 4
#define NR_DIRQS (32 - IPI_IRQ_OFFSET)

/* IRQ number definitions */
#define LOONGSON_LPC_IRQ_BASE		0
#define LOONGSON_LPC_LAST_IRQ		(LOONGSON_LPC_IRQ_BASE + 15)

#define MIPS_CPU_IRQ_BASE 		56
#define LOONGSON_UART_IRQ   		(MIPS_CPU_IRQ_BASE + 2) /* UART */
#define LOONGSON_BRIDGE_IRQ 		(MIPS_CPU_IRQ_BASE + 3) /* CASCADE */
#define LOONGSON_TIMER_IRQ  		(MIPS_CPU_IRQ_BASE + 7) /* CPU Timer */
#define MIPS_CPU_LAST_IRQ 		(MIPS_CPU_IRQ_BASE + 7)

#define LOONGSON_PCH_IRQ_BASE		64
#define LOONGSON_PCH_LAST_IRQ		(LOONGSON_PCH_IRQ_BASE + 63)

#define LOONGSON_PCI_MSI_IRQ_BASE	(LOONGSON_PCH_IRQ_BASE + 64)
#define LOONGSON_PCI_MSI_LAST_IRQ	(LOONGSON_PCH_IRQ_BASE + 256)

#define LOONGSON_IRQ2VEC(irq)		(irq - LOONGSON_PCH_IRQ_BASE)
#define LOONGSON_VEC2IRQ(vec)		(vec + LOONGSON_PCH_IRQ_BASE)

#define LOONGSON_HT1_CFG_BASE		loongson_sysconf.ht_control_base
#define LOONGSON_HT1_INT_VECTOR_BASE	(LOONGSON_HT1_CFG_BASE + 0x80)
#define LOONGSON_HT1_INT_EN_BASE	(LOONGSON_HT1_CFG_BASE + 0xa0)
#define LOONGSON_HT1_INT_VECTOR(n)	\
		LOONGSON3_REG32(LOONGSON_HT1_INT_VECTOR_BASE, 4 * (n))
#define LOONGSON_HT1_INTN_EN(n)		\
		LOONGSON3_REG32(LOONGSON_HT1_INT_EN_BASE, 4 * (n))
#define LOONGSON_HT1_INT_VECTOR64(n)	\
		LOONGSON3_REG64(LOONGSON_HT1_INT_VECTOR_BASE, 8 * (n))
#define LOONGSON_HT1_INTN_EN64(n)	\
		LOONGSON3_REG64(LOONGSON_HT1_INT_EN_BASE, 8 * (n))

#define LOONGSON_INT_ROUTER_OFFSET	0x1400
#define LOONGSON_INT_ROUTER_INTEN	\
	  LOONGSON3_REG32(LOONGSON3_REG_BASE, LOONGSON_INT_ROUTER_OFFSET + 0x24)
#define LOONGSON_INT_ROUTER_INTENSET	\
	  LOONGSON3_REG32(LOONGSON3_REG_BASE, LOONGSON_INT_ROUTER_OFFSET + 0x28)
#define LOONGSON_INT_ROUTER_INTENCLR	\
	  LOONGSON3_REG32(LOONGSON3_REG_BASE, LOONGSON_INT_ROUTER_OFFSET + 0x2c)
#define LOONGSON_INT_ROUTER_ENTRY(n)	\
	  LOONGSON3_REG8(LOONGSON3_REG_BASE, LOONGSON_INT_ROUTER_OFFSET + n)
#define LOONGSON_INT_ROUTER_UART0	LOONGSON_INT_ROUTER_ENTRY(0x0a)
#define LOONGSON_INT_ROUTER_UART1	LOONGSON_INT_ROUTER_ENTRY(0x0f)
#define LOONGSON_INT_ROUTER_HT1(n)	LOONGSON_INT_ROUTER_ENTRY(n + 0x18)

#define LOONGSON_INT_COREx_INTy(x, y)	(1<<(x) | 1<<(y+4))	/* route to int y of core x */

#define LS2H_PCH_IRQ_BASE		LOONGSON_PCH_IRQ_BASE
#define LS2H_PCH_ACPI_IRQ		(LS2H_PCH_IRQ_BASE + 0)
#define LS2H_PCH_HPET_IRQ		(LS2H_PCH_IRQ_BASE + 1)
#define LS2H_PCH_UART0_IRQ		(LS2H_PCH_IRQ_BASE + 2)
#define LS2H_PCH_UART1_IRQ		(LS2H_PCH_IRQ_BASE + 3)
#define LS2H_PCH_UART2_IRQ		(LS2H_PCH_IRQ_BASE + 4)
#define LS2H_PCH_UART3_IRQ		(LS2H_PCH_IRQ_BASE + 5)
#define LS2H_PCH_SPI_IRQ		(LS2H_PCH_IRQ_BASE + 6)
#define LS2H_PCH_I2C0_IRQ		(LS2H_PCH_IRQ_BASE + 7)
#define LS2H_PCH_I2C1_IRQ		(LS2H_PCH_IRQ_BASE + 8)
#define LS2H_PCH_AC97_IRQ		(LS2H_PCH_IRQ_BASE + 9)
#define LS2H_PCH_DMA0_IRQ		(LS2H_PCH_IRQ_BASE + 10)
#define LS2H_PCH_DMA1_IRQ		(LS2H_PCH_IRQ_BASE + 11)
#define LS2H_PCH_DMA2_IRQ		(LS2H_PCH_IRQ_BASE + 12)
#define LS2H_PCH_LPC_IRQ		(LS2H_PCH_IRQ_BASE + 13)
#define LS2H_PCH_RTC_INT0_IRQ		(LS2H_PCH_IRQ_BASE + 14)
#define LS2H_PCH_RTC_INT1_IRQ		(LS2H_PCH_IRQ_BASE + 15)
#define LS2H_PCH_RTC_INT2_IRQ		(LS2H_PCH_IRQ_BASE + 16)
#define LS2H_PCH_TOY_INT0_IRQ		(LS2H_PCH_IRQ_BASE + 17)
#define LS2H_PCH_TOY_INT1_IRQ		(LS2H_PCH_IRQ_BASE + 18)
#define LS2H_PCH_TOY_INT2_IRQ		(LS2H_PCH_IRQ_BASE + 19)
#define LS2H_PCH_RTC_TICK_IRQ		(LS2H_PCH_IRQ_BASE + 20)
#define LS2H_PCH_TOY_TICK_IRQ		(LS2H_PCH_IRQ_BASE + 21)
#define LS2H_PCH_NAND_IRQ		(LS2H_PCH_IRQ_BASE + 22)
#define LS2H_PCH_SYS_INTN_IRQ		(LS2H_PCH_IRQ_BASE + 23)
#define LS2H_PCH_EHCI_IRQ		(LS2H_PCH_IRQ_BASE + 32)
#define LS2H_PCH_OHCI_IRQ		(LS2H_PCH_IRQ_BASE + 33)
#define LS2H_PCH_OTG_IRQ		(LS2H_PCH_IRQ_BASE + 34)
#define LS2H_PCH_GMAC0_IRQ		(LS2H_PCH_IRQ_BASE + 35)
#define LS2H_PCH_GMAC1_IRQ		(LS2H_PCH_IRQ_BASE + 36)
#define LS2H_PCH_SATA_IRQ		(LS2H_PCH_IRQ_BASE + 37)
#define LS2H_PCH_GPU_IRQ		(LS2H_PCH_IRQ_BASE + 38)
#define LS2H_PCH_DC_IRQ			(LS2H_PCH_IRQ_BASE + 39)
#define LS2H_PCH_PWM0_IRQ		(LS2H_PCH_IRQ_BASE + 40)
#define LS2H_PCH_PWM1_IRQ		(LS2H_PCH_IRQ_BASE + 41)
#define LS2H_PCH_PWM2_IRQ		(LS2H_PCH_IRQ_BASE + 42)
#define LS2H_PCH_PWM3_IRQ		(LS2H_PCH_IRQ_BASE + 43)
#define LS2H_PCH_HT0_IRQ		(LS2H_PCH_IRQ_BASE + 44)
#define LS2H_PCH_HT1_IRQ		(LS2H_PCH_IRQ_BASE + 45)
#define LS2H_PCH_HT2_IRQ		(LS2H_PCH_IRQ_BASE + 46)
#define LS2H_PCH_HT3_IRQ		(LS2H_PCH_IRQ_BASE + 47)
#define LS2H_PCH_HT4_IRQ		(LS2H_PCH_IRQ_BASE + 48)
#define LS2H_PCH_HT5_IRQ		(LS2H_PCH_IRQ_BASE + 49)
#define LS2H_PCH_HT6_IRQ		(LS2H_PCH_IRQ_BASE + 50)
#define LS2H_PCH_HT7_IRQ		(LS2H_PCH_IRQ_BASE + 51)
#define LS2H_PCH_PCIE_PORT0_IRQ		(LS2H_PCH_IRQ_BASE + 52)
#define LS2H_PCH_PCIE_PORT1_IRQ		(LS2H_PCH_IRQ_BASE + 53)
#define LS2H_PCH_PCIE_PORT2_IRQ		(LS2H_PCH_IRQ_BASE + 54)
#define LS2H_PCH_PCIE_PORT3_IRQ		(LS2H_PCH_IRQ_BASE + 55)
#define LS2H_PCH_SATA_PHY_IRQ		(LS2H_PCH_IRQ_BASE + 56)
#define LS2H_PCH_HDA_IRQ		(LS2H_PCH_IRQ_BASE + 57)
#define LS2H_PCH_GPIO0_IRQ		(LS2H_PCH_IRQ_BASE + 64)
#define LS2H_PCH_GPIO1_IRQ		(LS2H_PCH_IRQ_BASE + 65)
#define LS2H_PCH_GPIO2_IRQ		(LS2H_PCH_IRQ_BASE + 66)
#define LS2H_PCH_GPIO3_IRQ		(LS2H_PCH_IRQ_BASE + 67)
#define LS2H_PCH_GPIO4_IRQ		(LS2H_PCH_IRQ_BASE + 68)
#define LS2H_PCH_GPIO5_IRQ		(LS2H_PCH_IRQ_BASE + 69)
#define LS2H_PCH_GPIO6_IRQ		(LS2H_PCH_IRQ_BASE + 70)
#define LS2H_PCH_GPIO7_IRQ		(LS2H_PCH_IRQ_BASE + 71)
#define LS2H_PCH_GPIO8_IRQ		(LS2H_PCH_IRQ_BASE + 72)
#define LS2H_PCH_GPIO9_IRQ		(LS2H_PCH_IRQ_BASE + 73)
#define LS2H_PCH_GPIO10_IRQ		(LS2H_PCH_IRQ_BASE + 74)
#define LS2H_PCH_GPIO11_IRQ		(LS2H_PCH_IRQ_BASE + 75)
#define LS2H_PCH_GPIO12_IRQ		(LS2H_PCH_IRQ_BASE + 76)
#define LS2H_PCH_GPIO13_IRQ		(LS2H_PCH_IRQ_BASE + 77)
#define LS2H_PCH_GPIO14_IRQ		(LS2H_PCH_IRQ_BASE + 78)
#define LS2H_PCH_GPIO15_IRQ		(LS2H_PCH_IRQ_BASE + 79)
#define LS2H_PCH_LAST_IRQ		(LS2H_PCH_IRQ_BASE + 160)

#define LS7A_PCH_IRQ_BASE		LOONGSON_PCH_IRQ_BASE
#define LS7A_PCH_UART0_IRQ		(LS7A_PCH_IRQ_BASE + 8)
#define LS7A_PCH_I2C0_IRQ		(LS7A_PCH_IRQ_BASE + 9)
#define LS7A_PCH_GMAC0_SBD_IRQ		(LS7A_PCH_IRQ_BASE + 12)
#define LS7A_PCH_GMAC0_PMT_IRQ		(LS7A_PCH_IRQ_BASE + 13)
#define LS7A_PCH_GMAC1_SBD_IRQ		(LS7A_PCH_IRQ_BASE + 14)
#define LS7A_PCH_GMAC1_PMT_IRQ		(LS7A_PCH_IRQ_BASE + 15)
#define LS7A_PCH_SATA0_IRQ		(LS7A_PCH_IRQ_BASE + 16)
#define LS7A_PCH_SATA1_IRQ		(LS7A_PCH_IRQ_BASE + 17)
#define LS7A_PCH_SATA2_IRQ		(LS7A_PCH_IRQ_BASE + 18)
#define LS7A_PCH_LPC_IRQ		(LS7A_PCH_IRQ_BASE + 19)
#define LS7A_PCH_PWM0_IRQ		(LS7A_PCH_IRQ_BASE + 24)
#define LS7A_PCH_PWM1_IRQ		(LS7A_PCH_IRQ_BASE + 25)
#define LS7A_PCH_PWM2_IRQ		(LS7A_PCH_IRQ_BASE + 26)
#define LS7A_PCH_PWM3_IRQ		(LS7A_PCH_IRQ_BASE + 27)
#define LS7A_PCH_DC_IRQ			(LS7A_PCH_IRQ_BASE + 28)
#define LS7A_PCH_GPU_IRQ		(LS7A_PCH_IRQ_BASE + 29)
#define LS7A_PCH_PCIE_F0_PORT0_IRQ	(LS7A_PCH_IRQ_BASE + 32)
#define LS7A_PCH_PCIE_F0_PORT1_IRQ	(LS7A_PCH_IRQ_BASE + 33)
#define LS7A_PCH_PCIE_F0_PORT2_IRQ	(LS7A_PCH_IRQ_BASE + 34)
#define LS7A_PCH_PCIE_F0_PORT3_IRQ	(LS7A_PCH_IRQ_BASE + 35)
#define LS7A_PCH_PCIE_F1_PORT0_IRQ	(LS7A_PCH_IRQ_BASE + 36)
#define LS7A_PCH_PCIE_F1_PORT1_IRQ	(LS7A_PCH_IRQ_BASE + 37)
#define LS7A_PCH_PCIE_H_LO_IRQ		(LS7A_PCH_IRQ_BASE + 38)
#define LS7A_PCH_PCIE_H_HI_IRQ		(LS7A_PCH_IRQ_BASE + 39)
#define LS7A_PCH_PCIE_G0_LO_IRQ		(LS7A_PCH_IRQ_BASE + 40)
#define LS7A_PCH_PCIE_G0_HI_IRQ		(LS7A_PCH_IRQ_BASE + 41)
#define LS7A_PCH_PCIE_G1_LO_IRQ		(LS7A_PCH_IRQ_BASE + 42)
#define LS7A_PCH_PCIE_G1_HI_IRQ		(LS7A_PCH_IRQ_BASE + 43)
#define LS7A_PCH_TOY0_IRQ		(LS7A_PCH_IRQ_BASE + 44)
#define LS7A_PCH_TOY1_IRQ		(LS7A_PCH_IRQ_BASE + 45)
#define LS7A_PCH_TOY2_IRQ		(LS7A_PCH_IRQ_BASE + 46)
#define LS7A_PCH_ACPI_IRQ		(LS7A_PCH_IRQ_BASE + 47)
#define LS7A_PCH_EHCI0_IRQ		(LS7A_PCH_IRQ_BASE + 48)
#define LS7A_PCH_OHCI0_IRQ		(LS7A_PCH_IRQ_BASE + 49)
#define LS7A_PCH_EHCI1_IRQ		(LS7A_PCH_IRQ_BASE + 50)
#define LS7A_PCH_OHCI1_IRQ		(LS7A_PCH_IRQ_BASE + 51)
#define LS7A_PCH_RTC_INT0_IRQ		(LS7A_PCH_IRQ_BASE + 52)
#define LS7A_PCH_RTC_INT1_IRQ		(LS7A_PCH_IRQ_BASE + 53)
#define LS7A_PCH_RTC_INT2_IRQ		(LS7A_PCH_IRQ_BASE + 54)
#define LS7A_PCH_HPET_IRQ		(LS7A_PCH_IRQ_BASE + 55)
#define LS7A_PCH_AC97_DMA0_IRQ		(LS7A_PCH_IRQ_BASE + 56)
#define LS7A_PCH_AC97_DMA1_IRQ		(LS7A_PCH_IRQ_BASE + 57)
#define LS7A_PCH_AC97_HDA_IRQ		(LS7A_PCH_IRQ_BASE + 58)
#define LS7A_PCH_GPIO_HI_IRQ		(LS7A_PCH_IRQ_BASE + 59)
#define LS7A_PCH_GPIO_0_IRQ		(LS7A_PCH_IRQ_BASE + 60)
#define LS7A_PCH_GPIO_1_IRQ		(LS7A_PCH_IRQ_BASE + 61)
#define LS7A_PCH_GPIO_2_IRQ		(LS7A_PCH_IRQ_BASE + 62)
#define LS7A_PCH_GPIO_3_IRQ		(LS7A_PCH_IRQ_BASE + 63)
#define LS7A_PCH_LAST_IRQ		(LS7A_PCH_IRQ_BASE + 63)

#define RS780_PCH_HPET_IRQ		0
#define RS780_PCH_ACPI_IRQ		7

#endif

extern struct irq_chip loongson_msi_irq_chip;
extern unsigned int loongson_ipi_irq2pos[NR_IRQS];
extern unsigned int loongson_ipi_pos2irq[NR_DIRQS];

extern void fixup_irqs(void);
extern void loongson3_send_irq_by_ipi(int cpu, int irqs);
extern void extioi_init(void);
extern void loongson3_ipi_interrupt(struct pt_regs *regs);

#include_next <irq.h>
#endif /* __ASM_MACH_LOONGSON64_IRQ_H_ */
