#/bin/sh

rm -rf ../include/ft_dsdt/*.hex

build_custom()
{
	if [ -f $2.dsl ]; then
		./iasl -tc $2.dsl || exit 1

		sed -i "s/AmlCode/$3/g" $2.hex

		cat $2.hex >> ../include/ft_dsdt/dsdt_$1.hex
		rm $2.hex
	fi
}

cat build_list | grep ^[^#] | while read line
do
	echo $line | awk -F ";" '{print $1,$2,$3}' | while read a b c
	do
		build_custom $a $b $c
	done

done
