#!/bin/bash

set -x

make mrproper ARCH=arm64 -j8
make mrproper ARCH=mips -j8
make mrproper ARCH=x86 -j8
git clean -xdf
make distclean -j8
fakeroot ./debian/rules clean
echo -n `git rev-parse HEAD` > .sourceversion
debuild --no-tgz-check -sa -S

changelog=`dpkg-parsechangelog -ldebian/changelog -o0 -c0 | sed -ne 's/^Version: *//p'`
dput lpdev:~kylin-kernel-team/kylinos-desktop/kernel-v10 ../kylin_${changelog}_source.changes
