#!/bin/bash

set -x

arch=`uname -m`

if [ ! -d .git ]; then
	echo "Please run this script in the root directory of project."
	exit -2;
fi

if [ "$1" == "--help" ]; then
	echo "Usage buildpackage.sh first.config [second.config] ..."
	exit -1;
fi

fakeroot ./debian/rules clean
if [ $? != 0 ]; then
	exit -1;
fi

TMPFILE=".config"

if [ -f TMPFILE ]; then
	rm -fr $TMPFILE
fi

for config in $@
do
	grep -rn "CONFIG_" $config &>/dev/null
	if [ $? != 0 ]; then
		echo "Ignore $config... that is not a config file."
		continue;
	fi

	cat $config >> $TMPFILE
done

if [ $# -ge 1 ]; then
make olddefconfig
fi

if [ -f $TMPFILE ]; then
	Arch=`echo $(arch) | sed -e s/i.86/x86/ -e s/x86_64/x86/ -e s/amd64/x86/ -e s/aarch64.*/arm64/ -e s/mips64el/mips/`
	\mv $TMPFILE arch/$Arch/configs/kylinos_generic_defconfig
fi

### clean
rm -rf config.tmp
make distclean

### build
dpkg-buildpackage -us -uc -b -d
