#ifndef __SEMEM_IOCTL_H__
#define __SEMEM_IOCTL_H__	1

#include <linux/ioctl.h>
#include "uapi/semem/semem_com.h"

#define SEMEM_MODULE	'S'

#define SEMEM_IOCTL_RULE_CMD		0x60
#define SEMEM_IOCTL_LOG_CMD			0x61

enum ioctl_rule_com_ops{
	SEMEM_RULE_SET,
	SEMEM_RULE_DISABLE,
	SEMEM_RULE_ENABLE,
	SEMEM_RULE_REMOVE,
	SEMEM_RULE_ATTR_CHG,
};

struct semem_ioctl_rule_com_ops_struct{
	enum ioctl_rule_com_ops rule_op;
	struct semem_range range;
	int ioctl_ret;
};

#define SEMEM_IOCTL_RULE_COM_OPS \
	_IOW(SEMEM_MODULE,\
		SEMEM_IOCTL_RULE_CMD,\
		struct semem_ioctl_rule_com_ops_struct)

struct semem_ioctl_log_count_struct{
	struct semem_range range;
	unsigned int log_count;
	int ioctl_ret;
};

struct semem_ioctl_log_struct{
	struct semem_range range;
	unsigned int total_cnt;
	unsigned int entry_cnt;
	unsigned int limit;
	unsigned long *va;
	unsigned char *type;
	int ioctl_ret;
};

#define SEMEM_IOCTL_LOG_COUNT \
	_IOR(SEMEM_MODULE,\
		SEMEM_IOCTL_LOG_CMD,\
		struct semem_ioctl_log_count_struct)

#define SEMEM_IOCTL_LOG \
	_IOR(SEMEM_MODULE,\
		SEMEM_IOCTL_LOG_CMD,\
		struct semem_ioctl_log_struct)
#endif

