/** @file semem_err.h
 *  @brief This file includes definitions of error code
 *  @author Montage
 *  @date   4/20/2018
 */
#ifndef __SEMEM_ERR_H__
#define __SEMEM_ERR_H__	1

#define ERR_SEMEM_NONE				0x0L    /**< no error while the function executes */
#define ERR_SEMEM_NOT_PERMIT		0x40L   /**< the operation is not permitted  */
#define ERR_SEMEM_INVALID			0x41L	/**< the parameter is not valid */
#define ERR_SEMEM_FAILED			0x42L   /**< something goes wrong when the function executes, eg, memory allocation failed, address decode failed, etc */
#define ERR_SEMEM_RULE_MAX			0x43L   /**< the number of the rule reaches the maxium number  */
#define ERR_SEMEM_ADDR_NOT_CONSECUTIVE	0x44L   /**< either virtual address range or system address is not consecutive */
#define ERR_SEMEM_ADDR_OVERLAP		0x45L   /**< the address of the security range is overlap with an existance one */
#define ERR_SEMEM_SCDIMM_NOT_SUPPORT	0x46L   /**< the platform has no SCDIMM */
#define ERR_SEMEM_ATTR				0x47	/**< the system address range is the same with an existance one and the attribute of the rule is not the same with current */
#define ERR_SEMEM_PROTO				0x48
#define ERR_SEMEM_RETRY				0x49
#define ERR_SEMEM_ABORT			    0x4a

#endif

