#ifndef __PHYS_RULE_H__
#define __PHYS_RULE_H__	1

#include <linux/types.h>
#include <linux/spinlock.h>
#include <linux/kref.h>
#include "uapi/semem/semem_ioctl.h"

/* phys_rule_struct should be a read-mostly data structure */
struct phys_rule_struct{
	struct kref ref;

	spinlock_t lock;

	unsigned long flags;
	unsigned long pa_start, pa_end;

	unsigned long sync;					/* sync to hsdimm register or not */

	unsigned long attr, status;

	struct list_head rcd_rule_head;
	struct list_head phys_rule_node;

	atomic_t ref_lrule_nr;
	struct list_head vma_rule_head;		/* fast lookup for logic rule */
};

#define phys_rule_of_list(node)	container_of((node), struct phys_rule_struct, phys_rule_node)

extern struct phys_rule_struct *phys_rule_find(unsigned long pa);
extern void phys_rule_put(struct phys_rule_struct *rule);
extern int phys_rule_set(unsigned long pa, unsigned long size, unsigned long attr, unsigned long status);
extern struct phys_rule_struct *phys_rule_prepare(unsigned long pa, unsigned long size,
								unsigned long attr, unsigned long status);
extern int phys_rule_sync(struct phys_rule_struct *rule, unsigned long status);
extern int phys_rule_remove(struct phys_rule_struct *rule);
extern int phys_rule_remove_range(unsigned long pa, unsigned long size);
extern int phys_rule_revoke(struct phys_rule_struct *phys_rule);
extern int phys_rule_status_change(struct phys_rule_struct *rule, unsigned long status);
extern int phys_rule_range_status_change(unsigned long pa, unsigned long size, unsigned long status);
extern int phys_rule_attribute_change(struct phys_rule_struct *rule, unsigned long attribute);
extern int phys_rule_fetch_log_cnt(unsigned long pa, unsigned long size, unsigned int *log_nr);
extern int phys_rule_fetch_log_entry(unsigned long pa, unsigned long size,
							unsigned long limit, unsigned long *buf);

#endif
