#ifndef _KSEMEM_H_
#define _KSEMEM_H_	1

#include <linux/types.h>
#include <linux/const.h>
#include "uapi/semem/semem_com.h"
#include "uapi/semem/semem_err.h"

enum ksemem_notify_nr{
	KSEMEM_CHIP_KEY_ATTACK,
	KSEMEM_DRIVER_KEY_ATTACK,
	KSEMEM_SECURE_AREA_ATTACK
};

struct ksemem_event{
	int event;
	pid_t pid;			/* task that is doing the attack */
	unsigned long count;
};

/*
*	ksemem_rule_set will set a new rule with a start address @virt_addr,
*   a memory length @len and memory attribute @flag
*
*	in	  :		virt_addr					the start address of memory range
*				len							the length of memory range
*				flag						the attribute of memory range
*
*	out	  :     reg_nr						will return the index within the register table.
*
*   return:		0  succeed
*				-ERR_SEMEM_NOT_PERMIT		the caller is not trusted
*				-ERR_SEMEM_INVALID			parameter is invalid
*				-ERR_SEMEM_FAILED			rule cannot be set
*				-ERR_SEMEM_RULE_MAX			there is no avaliable rule register
*/
extern int ksemem_rule_set(void *arg, struct semem_range *range);

extern int ksemem_rule_remove(void *arg, struct semem_range *range);

extern int ksemem_rule_disable(void *arg, struct semem_range *range);

extern int ksemem_rule_enable(void *arg, struct semem_range *range);

extern int ksemem_rule_attribute_update(void *arg, struct semem_range *range);

extern int ksemem_rule_get_log_count(void *arg, struct semem_range *range, unsigned int *log_nr);

extern int ksemem_event_notify_register(void *arg, struct notifier_block *nb);

/*
* common definition of secure key
*/
struct dimm_key_struct{
	unsigned int key_low;
	unsigned int key_high;
};

extern int rcd_init_key(struct dimm_key_struct keys[]);
extern int rcd_sync_random_key(struct dimm_key_struct keys[]);
extern int rcd_update_random_key(struct dimm_key_struct keys[]);

extern int secure_env_check(void);
#endif


