#ifndef __LINUX_FT_TPCM_H
#define __LINUX_FT_TPCM_H

#define OS_2_TPCM_BUFFER_OFFSET 0x0
#define TPCM_2_OS_BUFFER_OFFSET 0x800

typedef int (*FS_NOTIFIER)(int notify_type, int notify_length,
	unsigned long notify_sequence, unsigned long notify_addr_phys);
/* register notification callback function */
int ft_register_tpcm_notifier(FS_NOTIFIER notifier);
/* unregister notification callback function */
int ft_unregister_tpcm_notifier(FS_NOTIFIER notifier);
/* send command */
int ft_send_command(int cmd_type, int cmd_length, unsigned long cmd_sequence,
		unsigned long cmd_addr_phys, int *cmd_ret);

enum {
	CMD_TYPE_TPCM_SYNC = 0,	/* TPCM synchronization command */
	CMD_TYPE_TPCM_ASYNC = 8	/* TPCM asynchronous command */
};

enum {
	/* asynchronous command processing completion notify */
	NOTIFY_TYPE_CMD_FINISHED = 1,
	/* log output notify */
	NOTIFY_TYPE_CMD_LOG,
	/* auxiliary control notify */
	NOTIFY_TYPE_CMD_CONTROL
};

struct share_memory {
	uint32_t cmd_type;	/* command type */
	int32_t  cmd_length;	/* command content length */

	uint64_t cmd_sequence;	/* command sequence */
	/* command header physical address, pointing to cmd_header */
	uint64_t cmd_addr_phys;

	/*
	 * The command has been processed.
	 * It must be 0 when sending the command.
	 * It is set to 1 after the TPCM is processed.
	 * The host reads cmd_ret and resets cmd_handled to 0 after it finds it.
	 */
	uint32_t cmd_handled;
	/* command interrupt processing return value, set by TPCM */
	int32_t cmd_ret;

	int32_t notify_type;
	int32_t notify_length;
	uint64_t notify_sequence;
	/*
	 * notify pending flag, TPCM must be 0 when sending
	 * notification, set to 1 before sending, and reset to 0
	 * by host after processing notification interrupt
	 */

	/* notify physical address, set by TPCM */
	uint64_t notify_addr_phys;
	volatile uint32_t notify_pending;
	volatile uint32_t pad;

	/*
	 * data area that can be used to
	 * save the content of the notification
	 */
	/* char data_area[0]; */
} __packed;

struct cmd_header {
	/* input parameters */
	uint64_t input_addr;	/* command input address */
	uint64_t output_addr;	/* command output address */
	int32_t input_length;	/* command input length */
	int32_t output_maxlength;	/* maximum output buffer length */

	/* output parameters */
	/* save actual output length after command processing */
	int out_length;
	/* command execution result */
	int out_return;

} __packed;


void tsb_irq_handle(void);

#endif /* __LINUX_FT_TPCM_H */
