/*
 * arch/arm64/include/asm/xor.h
 *
 * Copyright (C) Xiaodong Liu <liuxiaodong@nudt.edu.cn>, Changsha, P.R. China
 * Copyright (C) 2015-2016 Jackie Liu <liuyun01@kylinos.cn>, Changsha, China
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/hardirq.h>
#include <asm-generic/xor.h>
#include <asm/hwcap.h>
#include <asm/neon.h>

#ifdef CONFIG_XOR_BLOCKS_OPTIMIZE_ARM64

extern struct xor_block_template const xor_block_inner_neonx4;
extern struct xor_block_template const xor_block_inner_neonx8;

static void
xor_neonx4_2(unsigned long bytes, unsigned long *p1, unsigned long *p2)
{
	kernel_neon_begin();
	xor_block_inner_neonx4.do_2(bytes, p1, p2);
	kernel_neon_end();
}

static void
xor_neonx4_3(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3)
{
	kernel_neon_begin();
	xor_block_inner_neonx4.do_3(bytes, p1, p2, p3);
	kernel_neon_end();
}

static void
xor_neonx4_4(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3, unsigned long *p4)
{
	kernel_neon_begin();
	xor_block_inner_neonx4.do_4(bytes, p1, p2, p3, p4);
	kernel_neon_end();
}

static void
xor_neonx4_5(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3, unsigned long *p4, unsigned long *p5)
{
	kernel_neon_begin();
	xor_block_inner_neonx4.do_5(bytes, p1, p2, p3, p4, p5);
	kernel_neon_end();
}

static struct xor_block_template xor_block_arm64x4 = {
	.name   = "arm64_neon_x4",
	.do_2   = xor_neonx4_2,
	.do_3   = xor_neonx4_3,
	.do_4   = xor_neonx4_4,
	.do_5	= xor_neonx4_5
};

static void
xor_neonx8_2(unsigned long bytes, unsigned long *p1, unsigned long *p2)
{
	kernel_neon_begin();
	xor_block_inner_neonx8.do_2(bytes, p1, p2);
	kernel_neon_end();
}

static void
xor_neonx8_3(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3)
{
	kernel_neon_begin();
	xor_block_inner_neonx8.do_3(bytes, p1, p2, p3);
	kernel_neon_end();
}

static void
xor_neonx8_4(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3, unsigned long *p4)
{
	kernel_neon_begin();
	xor_block_inner_neonx8.do_4(bytes, p1, p2, p3, p4);
	kernel_neon_end();
}

static void
xor_neonx8_5(unsigned long bytes, unsigned long *p1, unsigned long *p2,
	     unsigned long *p3, unsigned long *p4, unsigned long *p5)
{
	kernel_neon_begin();
	xor_block_inner_neonx8.do_5(bytes, p1, p2, p3, p4, p5);
	kernel_neon_end();
}

static struct xor_block_template xor_block_arm64x8 = {
	.name   = "arm64_neon_x8",
	.do_2   = xor_neonx8_2,
	.do_3   = xor_neonx8_3,
	.do_4   = xor_neonx8_4,
	.do_5	= xor_neonx8_5
};

#undef XOR_TRY_TEMPLATES
#define XOR_TRY_TEMPLATES           \
	do {        \
		xor_speed(&xor_block_8regs);    \
		xor_speed(&xor_block_32regs);    \
		if (cpu_has_neon()) { \
			xor_speed(&xor_block_arm64x4);\
			xor_speed(&xor_block_arm64x8);\
		} \
	} while (0)

#endif
