#ifndef __PHYPIUM_PLATFORM__
#define __PHYPIUM_PLATFORM__

#include <asm/cputype.h>

/********************* for all Phytium CPUs ******************/
static inline bool is_part(u32 cpuid)
{
	return ((read_cpuid_id() & MIDR_CPU_MODEL_MASK) == cpuid);
}

static inline bool is_implementer(u32 implementer)
{
	return ((read_cpuid_implementor() == implementer));
}

/**********************for phytium lpc************************/

extern void __iomem *lpc_base;
extern void __iomem *lpc_io_base;
extern int lpc_irq;

#define	PHYTIUM_LPC_NUM_SIRQS	32
extern DECLARE_BITMAP(ftlpc_sirq_bitmap, PHYTIUM_LPC_NUM_SIRQS);

extern int ftlpc_sirq_test_and_clear(u32 val);
extern void ftlpc_set_sirq_bitmap(int bit);
extern void ftlpc_clr_sirq_bitmap(int bit);
extern void ftlpc_disable_irq(void);
extern void ftlpc_enable_irq(void);

#ifdef CONFIG_FT_PINMUX
int ft_pinmux_select_gpio(int gpio);
#endif

extern struct mutex ft_efi_rtc_lock;

#endif
